/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.edideditor;

import com.quantumdata.edideditor.CEADescriptor;
import com.quantumdata.edideditor.DescriptorType;

public class CEAHdmiVSB
extends CEADescriptor {
    private int[] IEEE_header = new int[3];
    private int[] physical_address = new int[2];
    private int iSinkSettings;
    private int iMaxTMDSClock;
    private int iLatencyPresent;
    private int iVideoLatency;
    private int iAudioLatency;
    private int iInterlacedVideoLatency;
    private int iInterlacedAudioLatency;
    private final int MIN_BLOCK_SIZE = 5;

    public CEAHdmiVSB() {
        super(DescriptorType.HDMI_VSDB_DES, 0);
        this.IEEE_header[0] = 3;
        this.IEEE_header[1] = 12;
        this.IEEE_header[2] = 0;
    }

    public String getIEEEHeader() {
        String string = new String();
        string = string.concat(String.format("%02X", this.IEEE_header[2]));
        string = string.concat(String.format("%02X", this.IEEE_header[1]));
        string = string.concat(String.format("%02X", this.IEEE_header[0]));
        return string;
    }

    public void setPhysicalAddr(String string) {
        this.physical_address[0] = Integer.parseInt(string.substring(0, 2), 16);
        this.physical_address[1] = Integer.parseInt(string.substring(2, 4), 16);
        this.mySize = 5;
    }

    public void setSinkSettings(int n) {
        this.iSinkSettings = n;
        this.mySize = 6;
    }

    public void setMaxTMDSClk(int n) {
        this.iMaxTMDSClock = n;
        this.mySize = 7;
    }

    public void setLatencyPresent(int n) {
        this.iLatencyPresent = n;
        this.mySize = 8;
    }

    public void setVideoLatency(int n) {
        this.iVideoLatency = n;
        this.mySize = 9;
    }

    public void setAudioLatency(int n) {
        this.iAudioLatency = n;
        this.mySize = 10;
    }

    public void setIVideoLatency(int n) {
        this.iInterlacedVideoLatency = n;
        this.mySize = 11;
    }

    public void setIAudioLatency(int n) {
        this.iInterlacedAudioLatency = n;
        this.mySize = 12;
    }

    public void uploadDescriptorData(String string) {
        this.mySize = string.length() / 2;
        this.IEEE_header[0] = Integer.parseInt(string.substring(0, 2), 16);
        this.IEEE_header[1] = Integer.parseInt(string.substring(2, 4), 16);
        this.IEEE_header[2] = Integer.parseInt(string.substring(4, 6), 16);
        if (this.mySize >= 5) {
            this.physical_address[0] = Integer.parseInt(string.substring(6, 8), 16);
            this.physical_address[1] = Integer.parseInt(string.substring(8, 10), 16);
        }
        if (this.mySize >= 6) {
            this.iSinkSettings = Integer.parseInt(string.substring(10, 12), 16);
        }
        if (this.mySize >= 7) {
            this.iMaxTMDSClock = Integer.parseInt(string.substring(12, 14), 16);
        }
        if (this.mySize >= 8) {
            this.iLatencyPresent = Integer.parseInt(string.substring(14, 16), 16);
            if (this.isLatencyPresent()) {
                this.iVideoLatency = Integer.parseInt(string.substring(16, 18), 16);
                this.iAudioLatency = Integer.parseInt(string.substring(18, 20), 16);
            }
            if (this.isInterlacedLatencyPresent()) {
                this.iInterlacedVideoLatency = Integer.parseInt(string.substring(20, 22), 16);
                this.iInterlacedAudioLatency = Integer.parseInt(string.substring(22, 24), 16);
            }
        }
    }

    public String getIEEE() {
        String string = new String(String.format("%02X", this.IEEE_header[0]));
        string = string.concat(String.format("%02X", this.IEEE_header[1]));
        string = string.concat(String.format("%02X", this.IEEE_header[2]));
        return string;
    }

    public String getPhysicalAddr() {
        String string = new String();
        string = string.concat(String.format("%02X", this.physical_address[0]));
        string = string.concat(String.format("%02X", this.physical_address[1]));
        return string;
    }

    public int getSinkSettings() {
        return this.iSinkSettings;
    }

    public String getMaxTMDSClk() {
        if (this.mySize > 6) {
            return String.valueOf(this.iMaxTMDSClock);
        }
        return "";
    }

    public int getLatencyPresent() {
        return this.iLatencyPresent;
    }

    public boolean isLatencyPresent() {
        return (this.iLatencyPresent & 0x80) == 128;
    }

    public boolean isInterlacedLatencyPresent() {
        return (this.iLatencyPresent & 0x40) == 64;
    }

    public String getVideoLatency() {
        if (this.isLatencyPresent()) {
            return String.valueOf(this.iVideoLatency);
        }
        return "";
    }

    public String getAudioLatency() {
        if (this.isLatencyPresent()) {
            return String.valueOf(this.iAudioLatency);
        }
        return "";
    }

    public String getIVideoLatency() {
        if (this.isInterlacedLatencyPresent()) {
            return String.valueOf(this.iInterlacedVideoLatency);
        }
        return "";
    }

    public String getIAudioLatency() {
        if (this.isInterlacedLatencyPresent()) {
            return String.valueOf(this.iInterlacedAudioLatency);
        }
        return "";
    }

    public String extractDescriptorData() {
        String string = new String(this.getIEEE());
        string = string.concat(this.getPhysicalAddr());
        if (this.mySize > 5) {
            string = string.concat(String.format("%02X", this.iSinkSettings));
        }
        if (this.mySize > 6) {
            string = string.concat(String.format("%02X", Integer.valueOf(this.getMaxTMDSClk())));
        }
        if (this.mySize > 7) {
            string = string.concat(String.format("%02X", this.iLatencyPresent));
            if (this.isLatencyPresent()) {
                string = string.concat(String.format("%02X", Integer.valueOf(this.getVideoLatency())));
                string = string.concat(String.format("%02X", Integer.valueOf(this.getAudioLatency())));
            }
            if (this.isInterlacedLatencyPresent()) {
                string = string.concat(String.format("%02X", Integer.valueOf(this.getIVideoLatency())));
                string = string.concat(String.format("%02X", Integer.valueOf(this.getIAudioLatency())));
            }
        }
        return string;
    }
}

